<?php
/**
 * Plugin Name: SIMNSA Brokers Login
 * Description: Login personalizado para brokers vía API JWT.
 * Version: 1.0
 * Author: Mario Dominguez
 */
add_action('init', function () {
    if (!session_id()) {
        if (!headers_sent()) {
            session_start();
            error_log('73 Sesin iniciada correctamente.');
        } else {
            error_log('74 No se pudo iniciar sesin: headers ya enviados.');
        }
    } else {
        error_log('6715 Sesin ya estaba iniciada.');
    }
});

if (!defined('ABSPATH')) exit; // Seguridad

// Cargar archivos
define('SIMNSA_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('SIMNSA_PLUGIN_URL', plugin_dir_url(__FILE__));

// Incluir funciones necesarias
include_once SIMNSA_PLUGIN_PATH . 'includes/functions.php';

// Crear shortcode para el login
add_shortcode('simnsa_login_form', 'simnsa_render_login_form');

// Redirección si no hay sesión iniciada
add_action('template_redirect', 'simnsa_force_login');

// Mostrar los datos del broker
require_once plugin_dir_path(__FILE__) . 'includes/broker-profile-shortcode.php';

// Boton cerrar sesion en el menu
add_filter('wp_nav_menu_items', function ($items, $args) {
    if (isset($_SESSION['simnsa_token'])) {
        $logout_url = home_url('/logout');
        $items .= '<li><a href="' . esc_url($logout_url) . '">Log Out</a></li>';
    }
    return $items;
}, 10, 2);

add_action('init', function () {
    // Cerrar sesin si accede a /logout
    if (trim($_SERVER['REQUEST_URI'], '/') === 'logout') {
        $_SESSION = [];
        session_destroy();

        wp_redirect(home_url('/login'));
        exit;
    }
});

add_action('template_redirect', function () {
    if (is_user_logged_in()) return; // Admin de WordPress
    if (is_admin()) return; // Panel de administracin
    if (is_page('login')) return; // Ya est en la pgina de login

    if (!session_id()) session_start();

    // Redirige a /login si no hay token o ya expir
    if (empty($_SESSION['broker_token']) || time() > $_SESSION['broker_token_expiration']) {
        wp_redirect(site_url('/login'));
        exit;
    }
});

